/*
 * Decompiled with CFR 0.152.
 */
package net.betterthanadventure.utils;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.save.mcregion.RegionFile;
import net.minecraft.core.world.save.mcregion.RegionFileCache;

public class ResetBiomes {
    public static void main(String[] args) {
        File worldFolder = null;
        for (String arg : args) {
            int i = arg.indexOf(61);
            if (i == -1) {
                System.out.println("Skipping argument '" + arg + "'");
                continue;
            }
            String key = arg.substring(0, i);
            String value = arg.substring(i + 1);
            if (key.equals("world")) {
                worldFolder = new File(value);
                continue;
            }
            if (!key.equals("world-client")) continue;
            worldFolder = new File(Minecraft.getAppDir("minecraft-bta"), "saves/" + value);
        }
        if (worldFolder == null) {
            System.out.println("No world!");
            return;
        }
        new ResetBiomes(worldFolder);
    }

    public ResetBiomes(File worldFolder) {
        System.out.println("Reset Biomes: " + worldFolder.getAbsolutePath());
        ConsoleProgressUpdate progressUpdate = new ConsoleProgressUpdate();
        List<ChunkPosition> chunks = new McRegionChunkCounter().count(worldFolder, progressUpdate);
        System.out.println("Chunk Count: " + chunks.size());
        progressUpdate.progressStage("Converting Chunks");
        progressUpdate.progressStagePercentage(0);
        for (int i = 0; i < chunks.size(); ++i) {
            ChunkPosition chunk = chunks.get(i);
            FilterInputStream in = null;
            FilterOutputStream out = null;
            try {
                int chunkX = chunk.region.posX * 32 + chunk.posX;
                int chunkZ = chunk.region.posZ * 32 + chunk.posZ;
                in = RegionFileCache.getChunkInputStream(chunk.dimensionFolder, chunkX, chunkZ);
                if (in == null) {
                    throw new NullPointerException("Chunk input stream at " + chunkX + ", " + chunkZ + " is null!");
                }
                CompoundTag nbt = NbtIo.read((DataInput)((Object)in));
                in.close();
                CompoundTag nbtLevel = nbt.getCompound("Level");
                Map value = (Map)nbtLevel.getValue();
                value.remove("BiomeMap");
                value.remove("TemperatureMap");
                value.remove("HumidityMap");
                out = RegionFileCache.getChunkOutputStream(chunk.dimensionFolder, chunkX, chunkZ);
                NbtIo.write(nbt, (DataOutput)((Object)out));
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            ResetBiomes.setLoadingProgress(progressUpdate, i, chunks.size());
        }
        System.out.println("Done!");
    }

    public static List<String> split(String string, char c) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder last = null;
        for (int i = 0; i < string.length(); ++i) {
            char c1 = string.charAt(i);
            if (c1 == c) {
                if (last == null) continue;
                list.add(last.toString());
                last = null;
                continue;
            }
            if (last == null) {
                last = new StringBuilder();
            }
            last.append(c1);
        }
        if (last != null) {
            list.add(last.toString());
        }
        return list;
    }

    public static void setLoadingProgress(ProgressListener progressUpdate, int progress, int max) {
        float percent = (float)progress / (float)max;
        progressUpdate.progressStagePercentage((int)(percent * 100.0f));
    }

    static class ConsoleProgressUpdate
    implements ProgressListener {
        private String string;
        private long lastPrint = 0L;
        private int lastValue = 0;

        ConsoleProgressUpdate() {
        }

        @Override
        public void progressStart(String s) {
        }

        @Override
        public void progressStop() {
        }

        @Override
        public void progressStage(String s) {
            this.string = s;
            this.lastPrint = 0L;
        }

        @Override
        public void progressStagePercentage(int i) {
            if (i == this.lastValue) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now > this.lastPrint + 250L) {
                System.out.println(this.string + ": " + i + "%");
                this.lastPrint = now;
                this.lastValue = i;
            }
        }
    }

    static class RegionPosition {
        public final File file;
        public final File dimensionFolder;
        public final int posX;
        public final int posZ;
        public final int dimension;

        private RegionPosition(File file, File dimensionFolder, int x, int z, int dim) {
            this.file = file;
            this.dimensionFolder = dimensionFolder;
            this.posX = x;
            this.posZ = z;
            this.dimension = dim;
        }

        public String toString() {
            return this.file.toString();
        }

        public static RegionPosition get(File file) {
            int dim;
            File dimensionFolder = file.getParentFile().getParentFile();
            String dimFolderName = dimensionFolder.getName();
            try {
                dim = Integer.parseInt(dimFolderName);
            }
            catch (NumberFormatException e) {
                return null;
            }
            List<String> s = ResetBiomes.split(file.getName(), '.');
            if (s.size() != 4) {
                return null;
            }
            if (!s.get(0).equalsIgnoreCase("r")) {
                return null;
            }
            if (!s.get(3).equalsIgnoreCase("mcr")) {
                return null;
            }
            int x = Integer.parseInt(s.get(1));
            int z = Integer.parseInt(s.get(2));
            return new RegionPosition(file, dimensionFolder, x, z, dim);
        }
    }

    static class ChunkPosition {
        public final RegionPosition region;
        public final int dimension;
        public final File dimensionFolder;
        public final int posX;
        public final int posZ;

        public ChunkPosition(RegionPosition region, int posX, int posZ) {
            this.region = region;
            this.dimension = region.dimension;
            this.dimensionFolder = region.dimensionFolder;
            this.posX = posX;
            this.posZ = posZ;
        }
    }

    static class McRegionChunkCounter {
        private List<RegionPosition> regionList;
        private List<ChunkPosition> chunkList;

        McRegionChunkCounter() {
        }

        public List<ChunkPosition> count(File saveFolder, ProgressListener progressUpdate) {
            File[] dimensionFolders = new File(saveFolder, "dimensions").listFiles();
            System.out.println(dimensionFolders.length + " Dimension Folders");
            if (dimensionFolders == null || dimensionFolders.length == 0) {
                return null;
            }
            progressUpdate.progressStage("Counting Chunks");
            progressUpdate.progressStagePercentage(0);
            this.chunkList = new ArrayList<ChunkPosition>();
            this.regionList = new ArrayList<RegionPosition>();
            for (int dim = 0; dim < dimensionFolders.length; ++dim) {
                System.out.println("Dimension: " + dimensionFolders[dim].getName());
                File regionFolder = new File(dimensionFolders[dim], "region");
                File[] regionFiles = regionFolder.listFiles();
                if (regionFiles == null) {
                    System.out.println("No Region Files!");
                    continue;
                }
                System.out.println(regionFiles.length + " Region Files");
                for (int i = 0; i < regionFiles.length; ++i) {
                    RegionPosition region = RegionPosition.get(regionFiles[i]);
                    if (region == null) continue;
                    this.regionList.add(region);
                }
            }
            System.out.println("Region List: " + this.regionList.size());
            for (int i = 0; i < this.regionList.size(); ++i) {
                RegionPosition region = this.regionList.get(i);
                RegionFile regionFile = RegionFileCache.loadRegionFileFromCoords(region.dimensionFolder, region.posX << 5, region.posZ << 5);
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        if (!regionFile.chunkExists(x, z)) continue;
                        this.chunkList.add(new ChunkPosition(region, x, z));
                    }
                }
                ResetBiomes.setLoadingProgress(progressUpdate, i, this.regionList.size());
            }
            return this.chunkList;
        }
    }
}

