/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui.entries;

import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.util.ModListSearch;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public class ParentEntry
extends ModListEntry {
    private static final String PARENT_MOD_TEXTURE = "/assets/modmenu/textures/gui/parent_mod.png";
    protected List<ModContainer> children;
    protected ModListWidget list;
    protected boolean hoveringIcon = false;

    public ParentEntry(Minecraft mc, ModContainer parent, List<ModContainer> children, ModListWidget list) {
        super(mc, parent, list);
        this.children = children;
        this.list = list;
    }

    @Override
    public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, rowWidth, rowHeight, mouseX, mouseY, isSelected, delta);
        FontRenderer font = this.client.fontRenderer;
        int childrenBadgeHeight = 9;
        int childrenBadgeWidth = 9;
        int children = ModListSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        int childrenWidth = font.getStringWidth(Integer.toString(children)) - 1;
        if (childrenBadgeWidth < childrenWidth + 4) {
            childrenBadgeWidth = childrenWidth + 4;
        }
        int childrenBadgeX = x + 32 - childrenBadgeWidth;
        int childrenBadgeY = y + 32 - childrenBadgeHeight;
        int childrenOutlineColor = -2012163944;
        int childrenFillColor = -2012978874;
        this.drawRect(childrenBadgeX + 1, childrenBadgeY, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenOutlineColor);
        this.drawRect(childrenBadgeX, childrenBadgeY + 1, childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        this.drawRect(childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        this.drawRect(childrenBadgeX + 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight - 1, childrenFillColor);
        this.drawRect(childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight, childrenOutlineColor);
        font.drawString(Integer.toString(children), childrenBadgeX + childrenBadgeWidth / 2 - childrenWidth / 2, childrenBadgeY + 1, 0xCACACA);
        boolean bl = this.hoveringIcon = mouseX >= x - 1 && mouseX <= x - 1 + 32 && mouseY >= y - 1 && mouseY <= y - 1 + 32;
        if (this.isMouseOver(mouseX, mouseY)) {
            this.drawRect(x, y, x + 32, y + 32, -1601138544);
            this.client.renderEngine.bindTexture(this.client.renderEngine.getTexture(PARENT_MOD_TEXTURE));
            int xOffset = this.list.getParent().showModChildren.contains(this.getMetadata().getId()) ? 32 : 0;
            int yOffset = this.hoveringIcon ? 32 : 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tess = Tessellator.instance;
            tess.startDrawingQuads();
            tess.addVertexWithUV((double)x, (double)y, 0.0, (double)((float)xOffset / 256.0f), (double)((float)yOffset / 256.0f));
            tess.addVertexWithUV((double)x, (double)(y + 32), 0.0, (double)((float)xOffset / 256.0f), (double)((float)(yOffset + 32) / 256.0f));
            tess.addVertexWithUV((double)(x + 32), (double)(y + 32), 0.0, (double)((float)(xOffset + 32) / 256.0f), (double)((float)(yOffset + 32) / 256.0f));
            tess.addVertexWithUV((double)(x + 32), (double)y, 0.0, (double)((float)(xOffset + 32) / 256.0f), (double)((float)yOffset / 256.0f));
            tess.draw();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int i) {
        if (this.hoveringIcon) {
            String id = this.getMetadata().getId();
            if (this.list.getParent().showModChildren.contains(id)) {
                this.list.getParent().showModChildren.remove(id);
            } else {
                this.list.getParent().showModChildren.add(id);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
        }
        super.mouseClicked(mouseX, mouseY, i);
    }

    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 28) {
            String id = this.getMetadata().getId();
            if (this.list.getParent().showModChildren.contains(id)) {
                this.list.getParent().showModChildren.remove(id);
            } else {
                this.list.getParent().showModChildren.add(id);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public void setChildren(List<ModContainer> children) {
        this.children = children;
    }

    public void addChildren(List<ModContainer> children) {
        this.children.addAll(children);
    }

    public void addChildren(ModContainer ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<ModContainer> getChildren() {
        return this.children;
    }

    @Override
    public boolean isMouseOver(double double_1, double double_2) {
        return Objects.equals((Object)this.list.getEntryAtPos(double_1, double_2), (Object)this);
    }
}

