/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.gui.AlwaysSelectedEntryListWidget;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ModListEntry
extends AlwaysSelectedEntryListWidget.Entry<ModListEntry> {
    public static final String UNKNOWN_ICON = "/gui/unknown_pack.png";
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Minecraft client;
    protected final ModContainer container;
    protected final ModMetadata metadata;
    protected final ModListWidget list;
    protected Integer iconLocation;

    public ModListEntry(Minecraft mc, ModContainer container, ModListWidget list) {
        this.container = container;
        this.list = list;
        this.metadata = container.getMetadata();
        this.client = mc;
    }

    @Override
    public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        rowWidth -= this.getXOffset();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindIconTexture();
        ModListEntry.internalRender(y, x += this.getXOffset());
        String name = this.metadata.getName();
        if (name.equals("Minecraft")) {
            name = "Better than Adventure";
        }
        String trimmedName = name = HardcodedUtil.formatFabricModuleName(name);
        int maxNameWidth = rowWidth - 32 - 3;
        FontRenderer font = this.client.fontRenderer;
        trimmedName = ModListScreen.getString(font, name, trimmedName, maxNameWidth);
        font.drawString(trimmedName, x + 32 + 3, y + 1, 0xFFFFFF);
        new BadgeRenderer(this.client, x + 32 + 3 + font.getStringWidth(name) + 2, y, x + rowWidth, this.container, this.list.getParent()).draw(mouseX, mouseY);
        String description = this.metadata.getDescription();
        if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(this.metadata.getId())) {
            description = HardcodedUtil.getHardcodedDescription(this.metadata.getId());
        }
        RenderUtils.INSTANCE.drawWrappedString(font, description, x + 32 + 3 + 4, y + 9 + 2, rowWidth - 32 - 7, 2, 0x808080);
    }

    static void internalRender(int y, int x) {
        GL11.glEnable((int)3042);
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)x, (double)y, 0.0, 0.0, 0.0);
        tess.addVertexWithUV((double)x, (double)(y + 32), 0.0, 0.0, 1.0);
        tess.addVertexWithUV((double)(x + 32), (double)(y + 32), 0.0, 1.0, 1.0);
        tess.addVertexWithUV((double)(x + 32), (double)y, 0.0, 1.0, 0.0);
        tess.draw();
        GL11.glDisable((int)3042);
    }

    private BufferedImage createIcon() {
        BufferedImage bufferedImage;
        block12: {
            Path path = this.container.getPath(this.metadata.getIconPath(0).orElse("assets/" + this.metadata.getId() + "/icon.png"));
            BufferedImage cached = this.list.getCachedModIcon(path);
            if (cached != null) {
                return cached;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                ModContainer modMenu = (ModContainer)FabricLoader.getInstance().getModContainer("modmenu").orElseThrow(IllegalAccessError::new);
                path = HardcodedUtil.getFabricMods().contains(this.metadata.getId()) ? modMenu.getPath("assets/modmenu/fabric_icon.png") : (this.metadata.getId().equals("minecraft") ? modMenu.getPath("assets/modmenu/mc_icon.png") : (this.metadata.getId().equals("java") ? modMenu.getPath("assets/modmenu/java_icon.png") : modMenu.getPath("assets/modmenu/grey_fabric_icon.png")));
            }
            if ((cached = this.list.getCachedModIcon(path)) != null) {
                return cached;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                BufferedImage image = ImageIO.read(Objects.requireNonNull(inputStream));
                if (image.getHeight() != image.getWidth()) {
                    throw new IllegalStateException("Must be square icon");
                }
                this.list.cacheModIcon(path, image);
                bufferedImage = image;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Invalid icon for mod {}", (Object)this.container.getMetadata().getName(), (Object)t);
                    return null;
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    @Override
    public void mouseClicked(int v, int v1, int i) {
        this.list.select(this);
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public void bindIconTexture() {
        if (this.iconLocation == null) {
            BufferedImage icon = this.createIcon();
            this.iconLocation = icon != null ? Integer.valueOf(this.client.renderEngine.allocateAndSetupTexture(icon)) : Integer.valueOf(this.client.renderEngine.getTexture(UNKNOWN_ICON));
        }
        this.client.renderEngine.bindTexture(this.iconLocation.intValue());
    }

    public void deleteTexture() {
        if (this.iconLocation != null) {
            this.client.renderEngine.deleteTexture(this.iconLocation.intValue());
        }
    }

    public int getXOffset() {
        return 0;
    }
}

