/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.prospector.modmenu.api.ModMenuApi;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.HardcodedUtil;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.GuiOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMenu
implements ModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"modmenu");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final Map<String, Runnable> LEGACY_CONFIG_SCREEN_TASKS = new HashMap<String, Runnable>();
    public static final List<String> LIBRARY_MODS = new ArrayList<String>();
    public static final Set<String> CLIENTSIDE_MODS = new HashSet<String>();
    public static final Set<String> DEPRECATED_MODS = new HashSet<String>();
    public static final Set<String> PATCHWORK_FORGE_MODS = new HashSet<String>();
    public static final Map<String, Map<String, Map.Entry<Integer, Integer>>> CUSTOM_BADGE_MODS = new HashMap<String, Map<String, Map.Entry<Integer, Integer>>>();
    public static final LinkedListMultimap<ModContainer, ModContainer> PARENT_MAP = LinkedListMultimap.create();
    private static ImmutableMap<String, Function<GuiScreen, ? extends GuiScreen>> configScreenFactories = ImmutableMap.of();

    public static boolean hasConfigScreenFactory(String modid) {
        return configScreenFactories.containsKey((Object)modid);
    }

    public static GuiScreen getConfigScreen(String modid, GuiScreen menuScreen) {
        Function factory = (Function)configScreenFactories.get((Object)modid);
        return factory != null ? (GuiScreen)factory.apply(menuScreen) : null;
    }

    public static void openConfigScreen(String modid) {
        Runnable opener = LEGACY_CONFIG_SCREEN_TASKS.get(modid);
        if (opener != null) {
            opener.run();
        }
    }

    public static void addLegacyConfigScreenTask(String modid, Runnable task) {
        LEGACY_CONFIG_SCREEN_TASKS.putIfAbsent(modid, task);
    }

    public static boolean hasLegacyConfigScreenTask(String modid) {
        return LEGACY_CONFIG_SCREEN_TASKS.containsKey(modid);
    }

    public static void addLibraryMod(String modid) {
        if (LIBRARY_MODS.contains(modid)) {
            return;
        }
        LIBRARY_MODS.add(modid);
    }

    public void onInitialize() {
        ModMenuConfigManager.initializeConfig();
        ImmutableMap.Builder factories = ImmutableMap.builder();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
            ModContainer mod = entrypoint.getProvider();
            try {
                api.getClass().getDeclaredMethod("getConfigScreenFactory", new Class[0]);
                factories.put((Object)mod.getMetadata().getId(), api.getConfigScreenFactory());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            api.attachCustomBadges((name, outlineColor, fillColor) -> {
                HashMap<String, AbstractMap.SimpleEntry<Integer, Integer>> map = new HashMap<String, AbstractMap.SimpleEntry<Integer, Integer>>();
                map.put((String)name, new AbstractMap.SimpleEntry<Integer, Integer>((Integer)outlineColor, (Integer)fillColor));
                CUSTOM_BADGE_MODS.put(mod.getMetadata().getId(), map);
            });
        });
        factories.put((Object)"minecraft", screenBase -> new GuiOptions(screenBase, OptionsPages.GENERAL));
        configScreenFactories = factories.build();
        Collection mods = FabricLoader.getInstance().getAllMods();
        HardcodedUtil.initializeHardcodings();
        for (ModContainer mod : mods) {
            CustomValue.CvObject object;
            ModMetadata metadata = mod.getMetadata();
            String id = metadata.getId();
            if (metadata.containsCustomValue("modmenu:api") && metadata.getCustomValue("modmenu:api").getAsBoolean()) {
                ModMenu.addLibraryMod(id);
            }
            if (metadata.getEnvironment().equals((Object)ModEnvironment.CLIENT)) {
                CLIENTSIDE_MODS.add(id);
            }
            if (metadata.containsCustomValue("modmenu:clientsideOnly") && metadata.getCustomValue("modmenu:clientsideOnly").getAsBoolean()) {
                LOGGER.warn("Found mod with id \"{}\" using deprecated value \"modmenu:clientsideOnly\"!", (Object)metadata.getId());
                if (!CLIENTSIDE_MODS.contains(id)) {
                    CLIENTSIDE_MODS.add(id);
                }
            }
            if (metadata.containsCustomValue("modmenu:deprecated") && metadata.getCustomValue("modmenu:deprecated").getAsBoolean()) {
                DEPRECATED_MODS.add(id);
            }
            if (metadata.containsCustomValue("patchwork:source") && metadata.getCustomValue("patchwork:source").getAsObject() != null && "forge".equals((object = metadata.getCustomValue("patchwork:source").getAsObject()).get("loader").getAsString())) {
                PATCHWORK_FORGE_MODS.add(id);
            }
            if (metadata.containsCustomValue("modmenu:parent")) {
                String parentId = metadata.getCustomValue("modmenu:parent").getAsString();
                if (parentId == null) continue;
                Optional parent = FabricLoader.getInstance().getModContainer(parentId);
                parent.ifPresent(modContainer -> PARENT_MAP.put(modContainer, (Object)mod));
                continue;
            }
            HardcodedUtil.hardcodeModuleMetadata(mod, metadata, id);
        }
    }

    public static String getFormattedModCount() {
        return NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size());
    }
}

