/*
 * Decompiled with CFR 0.152.
 */
package bigsir.simplehealthindicator.render;

import bigsir.simplehealthindicator.SHealthIndicator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.HitResult;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    private static long lastNano = 0L;
    private static Entity entityCache = null;

    public static void renderInfo(Minecraft mc, float partialTick, long systemNano) {
        int renderOrder = (Integer)SHealthIndicator.renderOrder.value == 0 ? 1 : -1;
        long renderTimeLength = ((Integer)SHealthIndicator.displayTime.value).intValue();
        Entity entity = null;
        if (mc.objectMouseOver != null && mc.objectMouseOver.entity instanceof EntityLiving) {
            lastNano = systemNano;
            entity = entityCache = mc.objectMouseOver.entity;
        } else if (mc.objectMouseOver == null || mc.objectMouseOver.hitType != HitResult.HitType.ENTITY && entityCache != null) {
            if (entityCache != null && RenderUtils.entityCache.removed) {
                entityCache = null;
            }
            entity = entityCache;
            if ((systemNano - lastNano) / 1000000L > renderTimeLength * 100L) {
                entityCache = null;
            }
        }
        double scale = 0.3 * ((double)((Integer)SHealthIndicator.heartScale.value + 50) / 100.0);
        int heartsInRow = (Integer)SHealthIndicator.maxHearts.value + 2;
        if (entity != null) {
            boolean heartsFlash;
            float brightness = (Boolean)SHealthIndicator.healthFullbright.value != false ? ((Float)SHealthIndicator.healthBrightness.value).floatValue() : entity.getBrightness(partialTick);
            int hearts = MathHelper.ceilInt((int)((EntityLiving)entity).getMaxHealth(), (int)2);
            int length = Math.min(hearts, heartsInRow);
            int rows = MathHelper.ceilInt((int)hearts, (int)heartsInRow);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-mc.activeCamera.getX(partialTick)), (double)(-mc.activeCamera.getY(partialTick)), (double)(-mc.activeCamera.getZ(partialTick)));
            float playerHeight = entity instanceof EntityPlayer ? (((EntityPlayer)entity).isDwarf() ? 0.4f : 1.4f) : 0.0f;
            float heightOffset = entity.getHeadHeight() + (((EntityLiving)entity).nickname.isEmpty() ? 0.6f : 0.85f) + playerHeight;
            GL11.glTranslated((double)(entity.xo + (entity.x - entity.xo) * (double)partialTick), (double)(entity.yo + (entity.y - entity.yo) * (double)partialTick + (double)heightOffset), (double)(entity.zo + (entity.z - entity.zo) * (double)partialTick));
            GL11.glRotatef((float)(180.0f - (float)mc.activeCamera.getYRot(partialTick)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-mc.activeCamera.getXRot(partialTick))), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)(-((double)length - (double)(length - 1) / 9.0) / 2.0 * scale), (double)0.0, (double)0.0);
            Tessellator tessellator = Tessellator.instance;
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.001);
            boolean bl = heartsFlash = entity.heartsFlashTime / 3 % 2 == 1;
            if (entity.heartsFlashTime < 10) {
                heartsFlash = false;
            }
            int yOff = (rows - 1) * 4;
            double zOff = (double)(rows - 1) * 0.001;
            for (int i = 0; i < rows; ++i) {
                int xOff = 0;
                for (int j = 0; j < Math.min(hearts - i * heartsInRow, heartsInRow); ++j) {
                    RenderUtils.drawHeart(tessellator, heartsFlash ? 1 : 0, xOff, yOff, zOff, scale, brightness);
                    xOff += 8;
                    zOff -= 0.001 * (double)renderOrder;
                }
                yOff -= 4;
            }
            int health = ((EntityLiving)entity).getHealth();
            int healthFull = MathHelper.ceilInt((int)health, (int)2);
            boolean drawHalf = health % 2 != 0;
            int healthRow = MathHelper.ceilInt((int)healthFull, (int)heartsInRow);
            yOff = rows * 4;
            zOff = (double)(rows - 1) * 0.001 + 0.001;
            for (int i = 0; i < healthRow; ++i) {
                int xOff = 0;
                yOff -= 4;
                int heartsRemaining = Math.min(healthFull - i * heartsInRow, heartsInRow);
                for (int j = 0; j < heartsRemaining; ++j) {
                    RenderUtils.drawHeart(tessellator, drawHalf && i == healthRow - 1 && j == heartsRemaining - 1 ? 5 : 4, xOff, yOff, zOff, scale, brightness);
                    xOff += 8;
                    zOff -= 0.001 * (double)renderOrder;
                }
            }
            GL11.glPopMatrix();
        }
    }

    private static void drawHeart(Tessellator tessellator, int heartIndex, int xOffset, int yOffset, double zOffset, double scale, float brightness) {
        int offset = heartIndex * 9;
        double posX = (double)xOffset / 9.0;
        double posY = (double)yOffset / 9.0;
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(posX * scale, posY * scale, zOffset, (double)(16 + offset) / 256.0 + 1.0E-4, 0.03505625);
        tessellator.addVertexWithUV((posX + 1.0) * scale, posY * scale, zOffset, (double)(25 + offset) / 256.0 - 1.0E-4, 0.03505625);
        tessellator.addVertexWithUV((posX + 1.0) * scale, (posY + 1.0) * scale, zOffset, (double)(25 + offset) / 256.0 - 1.0E-4, 1.0E-4);
        tessellator.addVertexWithUV(posX * scale, (posY + 1.0) * scale, zOffset, (double)(16 + offset) / 256.0 + 1.0E-4, 1.0E-4);
        tessellator.draw();
    }

    public static Entity getCachedEntity() {
        return entityCache;
    }

    public static void setCachedEntity(Entity entity) {
        entityCache = entity;
        lastNano = System.nanoTime();
    }
}

