/*
 * Decompiled with CFR 0.152.
 */
package bigsir.simplehealthindicator.mixin;

import bigsir.simplehealthindicator.SHealthIndicator;
import bigsir.simplehealthindicator.options.IOption;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.BooleanOption;
import net.minecraft.client.option.FloatOption;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.RangeOption;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameSettings.class}, remap=false)
public abstract class GameSettingsMixin {
    @Unique
    public RangeOption maxHearts;
    @Unique
    public RangeOption heartScale;
    @Unique
    public RangeOption displayTime;
    @Unique
    public RangeOption renderOrder;
    @Unique
    public BooleanOption healthFullbright;
    @Unique
    public FloatOption healthBrightness;

    @Inject(method={"getDisplayString"}, at={@At(value="HEAD")}, cancellable=true)
    public void offsetDisplayValue(Option<?> option, CallbackInfoReturnable<String> cir) {
        if (option == SHealthIndicator.maxHearts) {
            cir.setReturnValue((Object)String.valueOf(this.maxHearts.getValueIndex() + 2));
        } else if (option == SHealthIndicator.heartScale) {
            cir.setReturnValue((Object)((double)(this.heartScale.getValueIndex() + 50) / 100.0 + "x"));
        } else if (option == SHealthIndicator.displayTime) {
            cir.setReturnValue((Object)((double)this.displayTime.getValueIndex() / 10.0 + "s"));
        } else if (option == SHealthIndicator.renderOrder) {
            cir.setReturnValue((Object)(this.renderOrder.getValueIndex() == 0 ? "Default" : "Guidebook"));
        } else if (option == SHealthIndicator.healthBrightness && !((Boolean)SHealthIndicator.healthFullbright.value).booleanValue()) {
            cir.setReturnValue((Object)"Disabled");
        }
    }

    @Inject(method={"<init>"}, at={@At(value="NEW", target="(Ljava/io/File;Ljava/lang/String;)Ljava/io/File;")})
    public void addOptions(Minecraft minecraft, File file, CallbackInfo ci) {
        SHealthIndicator.optionsInit((GameSettings)this);
        this.maxHearts = SHealthIndicator.maxHearts;
        this.heartScale = SHealthIndicator.heartScale;
        this.displayTime = SHealthIndicator.displayTime;
        this.renderOrder = SHealthIndicator.renderOrder;
        this.healthFullbright = SHealthIndicator.healthFullbright;
        this.healthBrightness = SHealthIndicator.healthBrightness;
    }

    @Inject(method={"optionChanged"}, at={@At(value="HEAD")})
    public void changeText(Option<?> option, CallbackInfo ci) {
        if (option == SHealthIndicator.healthFullbright) {
            ((IOption)SHealthIndicator.healthBrightnessComponent).simple_health_indicator$refreshString();
            ((IOption)SHealthIndicator.healthBrightnessComponent).simple_health_indicator$getSlider().enabled = (Boolean)SHealthIndicator.healthFullbright.value;
        }
    }
}

