/*
 * Decompiled with CFR 0.152.
 */
package jamdoggie.betterbattletowers.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityGolem
extends EntityMonster {
    private String texture;
    private int dormant;
    private int pathToEntity;
    private int growl;
    private int drops;
    public Entity field_21478_field_20156_b;
    public int field_21477_field_20160_c;

    public EntityGolem(World world, int i) {
        super(world);
        this.scoreValue = 10000;
        this.texture = "/entity/golem/golemdormant.png";
        this.moveSpeed = 0.35f;
        this.attackStrength = 8;
        this.setHealthRaw(150 + 15 * i);
        this.setSize(1.6f, 3.4f);
        this.xRot = 0.0f;
        this.dormant = 1;
        this.pathToEntity = 0;
        this.growl = 0;
        this.fireImmune = true;
        this.drops = 2 + 2 * i;
        this.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
    }

    public EntityGolem(World world) {
        super(world);
        this.scoreValue = 10000;
        this.texture = "/entity/golem/golem.png";
        this.moveSpeed = 0.35f;
        this.attackStrength = 8;
        this.setHealthRaw(300);
        this.setSize(1.6f, 3.4f);
        this.xRot = 0.0f;
        this.dormant = 0;
        this.pathToEntity = 0;
        this.growl = 0;
        this.fireImmune = true;
        this.drops = 1;
        this.moveTo(this.x, this.y, this.z, 0.0f, 0.0f);
    }

    public int getMaxHealth() {
        return 450;
    }

    public String getDefaultEntityTexture() {
        return this.getEntityTexture();
    }

    public String getEntityTexture() {
        return "/assets/betterbattletowers/textures" + this.texture;
    }

    public void remove() {
        if (this.getHealth() <= 0 || this.world.difficultySetting == 0) {
            super.remove();
        }
    }

    public void onDeath(Entity entity) {
        if (this.scoreValue > 0 && entity != null) {
            entity.awardKillScore((Entity)this, this.scoreValue);
        }
        if (!this.world.isClientSide) {
            int i = this.drops - this.random.nextInt(2);
            for (int j = 0; j < i; ++j) {
                this.spawnAtLocation(Item.diamond.id, 1);
            }
            i = this.random.nextInt(4) + 9;
            for (int k = 0; k < i; ++k) {
                this.spawnAtLocation(Block.slabStonePolished.id, 1);
            }
        }
        this.world.sendTrackedEntityStatusUpdatePacket((Entity)this, (byte)3);
    }

    public void knockBack(Entity entity, int i, double d, double d1) {
        this.moveSpeed = 0.35f + (float)((double)(450 - this.getHealth()) / 1750.0);
        if (this.random.nextInt(5) == 0) {
            this.xd *= 1.5;
            this.zd *= 1.5;
            this.yd += (double)0.6f;
        }
        this.pathToEntity = 150;
    }

    protected void lookForPlayer() {
        if (this.dormant == 1) {
            EntityPlayer entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 6.0);
            if (entityplayer != null && this.canEntityBeSeen((Entity)entityplayer)) {
                this.dormant = 0;
                this.world.playSoundEffect(null, SoundCategory.CAVE_SOUNDS, this.x, this.y, this.z, "ambient.cave.cave", 0.7f, 1.0f);
                this.world.playSoundAtEntity(null, (Entity)this, "betterbattletowers.golemawaken", this.getSoundVolume() * 2.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 1.8f);
                this.texture = "/entity/golem/golem.png";
                this.pathToEntity = 175;
            }
        } else {
            List list = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb.expand(6.0, 6.0, 6.0));
            boolean flag = false;
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity != this.entityToAttack) continue;
                flag = true;
                break;
            }
            this.pathToEntity = !flag && this.entityToAttack != null || this.growl == 1 ? --this.pathToEntity : 175;
        }
    }

    public void tick() {
        if (this.dormant == 0) {
            if (this.pathToEntity <= 0 && this.growl == 0) {
                if (this.entityToAttack instanceof EntityPlayer && this.world.getClosestPlayerToEntity((Entity)this, 24.0) == null) {
                    this.entityToAttack = null;
                } else if (!this.isHappy()) {
                    this.world.playSoundAtEntity(null, (Entity)this, "betterbattletowers.golemspecial", this.getSoundVolume() * 2.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 1.8f);
                    this.yd += 0.9;
                    this.growl = 1;
                } else {
                    this.pathToEntity = 150;
                }
            } else if ((this.pathToEntity <= -30 || this.onGround) && this.growl == 1) {
                if (this.getHealth() <= 425) {
                    this.prevHealth += 25;
                }
                this.world.createExplosion((Entity)this, this.x, this.y, this.z, 4.5f + (float)(this.drops - 2) / 4.0f);
                this.pathToEntity = 125;
                this.growl = 0;
            }
            super.tick();
        }
        this.lookForPlayer();
    }

    public boolean hurt(Entity attacker, int i, DamageType type) {
        return this.dormant != 1 && super.hurt(attacker, i, type);
    }

    public boolean save(CompoundTag nbttagcompound) {
        boolean canSave = super.save(nbttagcompound);
        if (canSave) {
            nbttagcompound.putByte("isDormant", (byte)this.dormant);
            nbttagcompound.putByte("hasGrowled", (byte)this.growl);
            nbttagcompound.putByte("rageCounter", (byte)this.pathToEntity);
            nbttagcompound.putByte("Drops", (byte)this.drops);
        }
        return canSave;
    }

    public void load(CompoundTag nbttagcompound) {
        super.load(nbttagcompound);
        this.dormant = nbttagcompound.getByte("isDormant") & 0xFF;
        this.growl = nbttagcompound.getByte("hasGrowled") & 0xFF;
        this.pathToEntity = nbttagcompound.getByte("rageCounter") & 0xFF;
        this.drops = nbttagcompound.getByte("Drops") & 0xFF;
        this.moveSpeed = 0.35f + (float)((double)(450 - this.getHealth()) / 1750.0);
        this.texture = this.dormant == 1 ? "/entity/golem/golemdormant.png" : "/entity/golem/golem.png";
        this.attackStrength = 8;
    }

    protected boolean isHappy() {
        return false;
    }

    protected void attackEntity(Entity entity, float f) {
        if ((double)f < 3.0 && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            entity.hurt((Entity)this, this.attackStrength, DamageType.COMBAT);
        }
        if (this.onGround) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            float f1 = MathHelper.sqrt_double((double)(d * d + d1 * d1));
            this.xd = d / (double)f1 * 0.5 * 0.20000000192092895 + this.xd * 0.20000000098023224;
            this.zd = d1 / (double)f1 * 0.5 * 0.10000000192092896 + this.zd * 0.20000000098023224;
        } else {
            super.attackEntity(entity, f);
        }
    }

    public String getLivingSound() {
        if (this.dormant == 0) {
            return "betterbattletowers.golem";
        }
        return null;
    }

    protected String getHurtSound() {
        return "betterbattletowers.golemhurt";
    }

    protected String getDeathSound() {
        return "betterbattletowers.golemdeath";
    }

    protected void dropFewItems() {
        this.spawnAtLocation(new ItemStack(Item.brickClay, 1, 0), 0.0f);
    }
}

