/*
 * Decompiled with CFR 0.152.
 */
package jamdoggie.betterbattletowers;

import jamdoggie.betterbattletowers.block.ModBlocks;
import jamdoggie.betterbattletowers.entity.EntityGolem;
import jamdoggie.betterbattletowers.entity.render.RenderGolem;
import jamdoggie.betterbattletowers.worldgen.WorldGenTower;
import java.util.Properties;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.helper.EntityHelper;
import turniplabs.halplibe.helper.SoundHelper;
import turniplabs.halplibe.util.ClientStartEntrypoint;
import turniplabs.halplibe.util.ConfigHandler;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;

public class BetterBattleTowers
implements ModInitializer,
GameStartEntrypoint,
RecipeEntrypoint,
ClientModInitializer,
ClientStartEntrypoint {
    public static final String MOD_ID = "betterbattletowers";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"betterbattletowers");
    public static ConfigHandler config;
    public static BetterBattleTowers instance;
    public static int towercount;
    public static int rarity;
    private final int DEFAULT_RARITY = 3;
    public static int entityID;

    public BetterBattleTowers() {
        instance = this;
    }

    public void onInitialize() {
        LOGGER.info("Better than Battle Towers initialized.");
    }

    public void beforeGameStart() {
        ModBlocks.createBlocks();
        EntityHelper.createEntity(EntityGolem.class, (int)entityID, (String)"TowerGolem", () -> new RenderGolem());
    }

    public void beforeClientStart() {
    }

    public void afterClientStart() {
    }

    public void afterGameStart() {
        MobInfoRegistry.register(EntityGolem.class, (String)"betterbattletowers.golem.name", (String)"betterbattletowers.golem.desc", (int)300, (int)10000, (MobInfoRegistry.MobDrop[])new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Block.slabStonePolished), 1.0f, 9, 12), new MobInfoRegistry.MobDrop(new ItemStack(Item.diamond), 1.0f, 1, 6)});
    }

    public void onRecipesReady() {
    }

    public void initNamespaces() {
    }

    public void onInitializeClient() {
        SoundHelper.addSound((String)MOD_ID, (String)"golem1.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golem3.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golemawaken.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golemdeath.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golemhurt2.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golemhurt3.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golemspecial1.ogg");
        SoundHelper.addSound((String)MOD_ID, (String)"golemspecial2.ogg");
    }

    public void GenerateSurface(World world, Random random, int chunkX, int chunkZ) {
        if (towercount >= rarity * 100) {
            int i1;
            int l;
            int k;
            if (random.nextInt(2) == 0 && new WorldGenTower().generate(world, random, k = chunkX + random.nextInt(16) + 8, l = world.getHeightValue(k, i1 = chunkZ + random.nextInt(16) + 8), i1)) {
                towercount = 0;
            }
        } else {
            ++towercount;
        }
    }

    static {
        Properties prop = new Properties();
        prop.setProperty("towercount", "200");
        prop.setProperty("rarity", "10");
        prop.setProperty("starting_block_id", "6340");
        prop.setProperty("starting_item_id", "26340");
        prop.setProperty("starting_entity_id", "634");
        config = new ConfigHandler(MOD_ID, prop);
        entityID = config.getInt("starting_entity_id");
        towercount = config.getInt("towercount");
        rarity = config.getInt("rarity");
        config.updateConfig();
    }
}

